/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.exporters;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class JCheckList<E>
extends JPanel {
    private DefaultListModel listaModel;
    private JList lista;
    private JScrollPane scrollPane;

    public JCheckList() {
        this.initComponents();
        this.listaModel = new DefaultListModel();
        this.lista.setModel(this.listaModel);
        this.iniciar();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.lista = new JList();
        this.setLayout(new BoxLayout(this, 2));
        this.scrollPane.setViewportView(this.lista);
        this.add(this.scrollPane);
    }

    public void setData(List<E> items) {
        this.listaModel.removeAllElements();
        for (E algo : items) {
            this.listaModel.addElement(new CheckListItem(algo));
        }
    }

    public List<E> getSelectedItems() {
        ArrayList salida = new ArrayList();
        int i = 0;
        while (i < this.listaModel.getSize()) {
            CheckListItem item = (CheckListItem)this.listaModel.get(i);
            if (item.isSelected) {
                salida.add(item.getContenido());
            }
            ++i;
        }
        return salida;
    }

    public void setSelectedItems(List<E> selection) {
        int i = 0;
        while (i < this.listaModel.getSize()) {
            ((CheckListItem)this.listaModel.get(i)).setSelected(false);
            ++i;
        }
        block1: for (E item : selection) {
            int i2 = 0;
            while (i2 < this.listaModel.getSize()) {
                if (((CheckListItem)this.listaModel.get(i2)).equals(item)) {
                    ((CheckListItem)this.listaModel.get(i2)).setSelected(true);
                    continue block1;
                }
                ++i2;
            }
        }
        this.repaint();
    }

    public void setSelectAll() {
        int i = 0;
        while (i < this.listaModel.getSize()) {
            ((CheckListItem)this.listaModel.get(i)).setSelected(true);
            ++i;
        }
        this.repaint();
    }

    public void setDeselectAll() {
        int i = 0;
        while (i < this.listaModel.getSize()) {
            ((CheckListItem)this.listaModel.get(i)).setSelected(false);
            ++i;
        }
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.lista.setEnabled(enabled);
    }

    private void iniciar() {
        this.lista.setCellRenderer(new CheckListRenderer());
        this.lista.setSelectionMode(0);
        this.lista.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CheckListItem item;
                if (!JCheckList.this.lista.isEnabled()) {
                    return;
                }
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                if (index < 0) {
                    return;
                }
                item.setSelected(!(item = (CheckListItem)list.getModel().getElementAt(index)).isSelected());
                list.repaint(list.getCellBounds(index, index));
            }
        });
    }

    public void addCheckListItem(String label, E item) {
        this.listaModel.addElement(new CheckListItem(label, item));
    }

    private class CheckListItem {
        private String label;
        private boolean isSelected = false;
        private E contenido = null;

        public CheckListItem(String label) {
            this.label = label;
        }

        public CheckListItem(E contenido) {
            this.contenido = contenido;
            this.label = contenido.toString();
        }

        public CheckListItem(String label, E contenido) {
            this.label = label;
            this.contenido = contenido;
        }

        private CheckListItem() {
        }

        public E getContenido() {
            return this.contenido;
        }

        public void setContenido(E contenido) {
            this.contenido = contenido;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object obj) {
            return this.contenido.equals(obj);
        }
    }

    private class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private CheckListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(((CheckListItem)value).isSelected());
            this.setFont(list.getFont());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setText(value.toString());
            return this;
        }
    }
}

